/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Animatable;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Easing;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.Mth;

public class Animation<A extends Animatable<A>> {
    private final int duration;
    private float delta = 0.0f;
    private Direction direction = Direction.BACKWARDS;
    private boolean looping = false;
    private final Consumer<A> setter;
    private final Easing easing;
    private final A from;
    private final A to;

    public Animation(int duration, Consumer<A> setter, Easing easing, A from, A to) {
        this.duration = duration;
        this.setter = setter;
        this.easing = easing;
        this.from = from;
        this.to = to;
    }

    public static Composed compose(Animation<?> ... elements) {
        return new Composed(elements);
    }

    public void update(float delta) {
        if (this.delta == this.direction.targetDelta) {
            if (this.looping) {
                this.direction = this.direction.reversed();
            } else {
                return;
            }
        }
        this.delta = Mth.m_14036_((float)(this.delta + delta * 50.0f / (float)this.duration * (float)this.direction.multiplier), (float)0.0f, (float)1.0f);
        this.setter.accept(this.from.interpolate(this.to, this.easing.apply(this.delta)));
    }

    public Animation<A> forwards() {
        this.direction = Direction.FORWARDS;
        return this;
    }

    public Animation<A> backwards() {
        this.direction = Direction.BACKWARDS;
        return this;
    }

    public Animation<A> reverse() {
        this.direction = this.direction.reversed();
        return this;
    }

    public Animation<A> loop(boolean loop) {
        this.looping = loop;
        return this;
    }

    public boolean looping() {
        return this.looping;
    }

    public Direction direction() {
        return this.direction;
    }

    public static enum Direction {
        FORWARDS(1, 1.0f),
        BACKWARDS(-1, 0.0f);

        public final int multiplier;
        public final float targetDelta;

        private Direction(int multiplier, float targetDelta) {
            this.multiplier = multiplier;
            this.targetDelta = targetDelta;
        }

        public Direction reversed() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FORWARDS -> BACKWARDS;
                case BACKWARDS -> FORWARDS;
            };
        }
    }

    public static class Composed {
        private final List<Animation<?>> elements;

        private Composed(Animation<?> ... elements) {
            this.elements = Arrays.asList(elements);
        }

        public void forwards() {
            this.elements.forEach(Animation::forwards);
        }

        public void backwards() {
            this.elements.forEach(Animation::backwards);
        }

        public void reverse() {
            this.elements.forEach(Animation::reverse);
        }

        public void loop(boolean loop) {
            this.elements.forEach(animation -> animation.loop(loop));
        }
    }
}

